/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util;

import me.jellysquid.mods.sodium.client.world.VanillaFluidBlock;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import repack.joml.Vector3d;

public class WorldUtil {
    public static Vector3d getVelocity(IBlockAccess world, BlockPos pos, IBlockState thizz) {
        Vector3d velocity = new Vector3d();
        int decay = WorldUtil.getEffectiveFlowDecay(world, pos, thizz);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
        for (EnumFacing dire : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            int adjX = pos.func_177958_n() + dire.func_82601_c();
            int adjZ = pos.func_177952_p() + dire.func_82599_e();
            mutable.func_181079_c(adjX, pos.func_177956_o(), adjZ);
            int adjDecay = WorldUtil.getEffectiveFlowDecay(world, (BlockPos)mutable, thizz);
            if (adjDecay < 0) {
                if (world.func_180495_p((BlockPos)mutable).func_185904_a().func_76230_c() || (adjDecay = WorldUtil.getEffectiveFlowDecay(world, mutable.func_177977_b(), thizz)) < 0) continue;
                velocity = velocity.add((adjX - pos.func_177958_n()) * (adjDecay -= decay - 8), 0.0, (adjZ - pos.func_177952_p()) * adjDecay);
                continue;
            }
            velocity = velocity.add((adjX - pos.func_177958_n()) * (adjDecay -= decay), 0.0, (adjZ - pos.func_177952_p()) * adjDecay);
        }
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) >= 8 && (thizz.isSideSolid(world, pos.func_177978_c(), EnumFacing.NORTH) || thizz.isSideSolid(world, pos.func_177968_d(), EnumFacing.SOUTH) || thizz.isSideSolid(world, pos.func_177976_e(), EnumFacing.WEST) || thizz.isSideSolid(world, pos.func_177974_f(), EnumFacing.EAST) || thizz.isSideSolid(world, pos.func_177984_a().func_177968_d(), EnumFacing.NORTH) || thizz.isSideSolid(world, pos.func_177984_a().func_177976_e(), EnumFacing.SOUTH) || thizz.isSideSolid(world, pos.func_177984_a().func_177976_e(), EnumFacing.WEST) || thizz.isSideSolid(world, pos.func_177984_a().func_177974_f(), EnumFacing.EAST))) {
            velocity = velocity.normalize().add(0.0, -6.0, 0.0);
        }
        if (velocity.x == 0.0 && velocity.y == 0.0 && velocity.z == 0.0) {
            return velocity.zero();
        }
        return velocity.normalize();
    }

    public static boolean method_15756(IBlockAccess world, BlockPos pos, Fluid fluid) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                IBlockState block = world.func_180495_p(pos);
                if (block.func_185914_p() || WorldUtil.getFluid(block) == fluid) continue;
                return true;
            }
        }
        return false;
    }

    public static float getFluidHeight(Fluid fluid, int meta) {
        return fluid == null ? 0.0f : 1.0f - BlockLiquid.func_149801_b((int)meta);
    }

    public static int getEffectiveFlowDecay(IBlockAccess world, BlockPos pos, IBlockState thiz) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() != thiz.func_185904_a()) {
            return -1;
        }
        int decay = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        return decay >= 8 ? 0 : decay;
    }

    public static boolean shouldDisplayFluidOverlay(IBlockState block) {
        return !block.func_185904_a().func_76218_k() || block.func_185904_a() == Material.field_151584_j;
    }

    public static Fluid getFluid(IBlockState b) {
        IFluidBlock fluidBlock = WorldUtil.toFluidBlock(b.func_177230_c());
        return fluidBlock != null ? fluidBlock.getFluid() : null;
    }

    public static boolean isEmptyOrSame(Fluid fluid, Fluid otherFluid) {
        return otherFluid == null || fluid == otherFluid;
    }

    public static boolean method_15749(IBlockAccess world, Fluid thiz, BlockPos pos, EnumFacing dir) {
        IBlockState b = world.func_180495_p(pos);
        Fluid f = WorldUtil.getFluid(b);
        if (f == thiz) {
            return false;
        }
        if (dir == EnumFacing.UP) {
            return true;
        }
        return b.func_185904_a() != Material.field_151588_w && b.isSideSolid(world, pos, dir);
    }

    public static IFluidBlock toFluidBlock(Block block) {
        if (block instanceof VanillaFluidBlock) {
            return ((VanillaFluidBlock)block).getFakeFluidBlock();
        }
        if (block instanceof IFluidBlock) {
            return (IFluidBlock)block;
        }
        return null;
    }

    public static Fluid getFluidOfBlock(Block block) {
        IFluidBlock fluidBlock = WorldUtil.toFluidBlock(block);
        return fluidBlock != null ? fluidBlock.getFluid() : null;
    }
}

